package view;

import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import model.ProxyExecution;

public class ComparisonsPanel extends JPanel {

	private ProxyExecution execution;
	private Checkbox[] checks = new Checkbox[6];
	// private JLabel[] labels = new JLabel[6];
	private JLabel labels;

	public ComparisonsPanel(ProxyExecution execution) {
		this.execution = execution;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(6, 1));

		checks[0] = new Checkbox("1");
		checks[1] = new Checkbox("2");
		checks[2] = new Checkbox("3");
		checks[3] = new Checkbox("4");
		checks[4] = new Checkbox("5");
		checks[5] = new Checkbox("6");

		for (int i = 0; i < checks.length; i++) {
			checks[i].setState(false);
			add(checks[i]);
		}
		// ComparisonListener listener = new ComparisonListener(execution,
		// checks);

		for (int i = 0; i < checks.length; i++) {
			checks[i].addItemListener(new ItemListener() {

				ProxyExecution execution = getExec();

				@Override
				public void itemStateChanged(ItemEvent e) {
					for (int j = 0; j < checks.length; j++) {
						execution.setActives(j, checks[j].getState());
					}

				}
			});
		}

	}

	public ProxyExecution getExec() {
		return this.execution;
	}

}
